<?php
namespace local_consultadb;

defined('MOODLE_INTERNAL') || die();
require_once("$CFG->libdir/externallib.php");

class external extends \external_api {

    // 1️⃣ Sin parámetros de entrada
    public static function get_items_parameters() {
        return new \external_function_parameters([]);
    }

    // 2️⃣ Nueva lógica: para cada usuario buscar su ID y luego sus calificaciones
    public static function get_items() {
        global $DB;

        // 2.1 Obtener todos los usuarios activos (sin guest, no borrados, no suspendidos)
        $users = $DB->get_records_select(
            'user',
            "deleted = 0 AND suspended = 0 AND username <> 'guest'",
            null,
            'id ASC',
            'id, username'
        );

        $salida = [];

        foreach ($users as $u) {
            // 2.2 Buscar explícitamente el ID (aunque ya lo tenemos) para mantener el flujo original
            $userid = $DB->get_field('user', 'id', ['username' => $u->username], IGNORE_MISSING);
            if (!$userid) {
                // si por alguna razón no existe, se salta
                continue;
            }

            // 2.3 Consultar calificaciones en grade_grades
            $sql = "SELECT
                        gg.itemid,
                        gg.finalgrade AS grade
                    FROM {grade_grades} gg
                    WHERE gg.userid = :userid
                    ORDER BY gg.itemid";

            $rs = $DB->get_recordset_sql($sql, ['userid' => $userid]);

            $grades = [];
            foreach ($rs as $r) {
                $grades[] = [
                    'itemid' => (int)$r->itemid,
                    'grade'  => is_null($r->grade) ? null : (string)$r->grade
                ];
            }
            $rs->close();

            // 2.4 Agregar a la salida el username y sus calificaciones
            $salida[] = [
                'username' => $u->username,
                'grades'   => $grades
            ];
        }

        return $salida;
    }

    // 3️⃣ Estructura de salida
    public static function get_items_returns() {
        return new \external_multiple_structure(
            new \external_single_structure([
                'username' => new \external_value(PARAM_RAW, 'Username del usuario en Moodle'),
                'grades'   => new \external_multiple_structure(
                    new \external_single_structure([
                        'itemid' => new \external_value(PARAM_INT, 'ID del ítem de calificación'),
                        'grade'  => new \external_value(
                            PARAM_RAW,
                            'Calificación final (puede ser null)',
                            VALUE_OPTIONAL
                        )
                    ])
                )
            ])
        );
    }
}
